/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.component.hl7.HL7MLLPConfig;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HL7MLLPEncoder
implements ProtocolEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(HL7MLLPEncoder.class);
    private HL7MLLPConfig config;

    HL7MLLPEncoder(HL7MLLPConfig config) {
        this.config = config;
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        byte[] body;
        if (message == null) {
            throw new IllegalArgumentException("Message to be encoded is null");
        }
        if (message instanceof Exception) {
            throw (Exception)message;
        }
        if (message instanceof Message) {
            body = ((Message)message).encode().getBytes(this.config.getCharset());
        } else if (message instanceof String) {
            body = ((String)message).getBytes(this.config.getCharset());
        } else if (message instanceof byte[]) {
            body = (byte[])message;
        } else {
            throw new IllegalArgumentException("The message to encode is not a supported type: " + message.getClass().getCanonicalName());
        }
        IoBuffer buf = IoBuffer.allocate((int)(body.length + 3)).setAutoExpand(true);
        buf.put((byte)this.config.getStartByte());
        buf.put(body);
        buf.put((byte)this.config.getEndByte1());
        buf.put((byte)this.config.getEndByte2());
        buf.flip();
        LOG.debug("Encoded HL7 from {} to byte stream", (Object)message.getClass().getCanonicalName());
        out.write((Object)buf);
    }
}

