/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos.integration.producer;

import org.apache.camel.Endpoint;
import org.apache.camel.component.atmos.AtmosConfiguration;
import org.apache.camel.component.atmos.AtmosEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtmosProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(AtmosProducer.class);
    protected AtmosEndpoint endpoint;
    protected AtmosConfiguration configuration;

    public AtmosProducer(AtmosEndpoint endpoint, AtmosConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.createClient();
            LOG.info("producer atmos client created");
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.setClient(null);
            LOG.info("producer atmos client deleted");
        }
        super.doStop();
    }
}

