/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class DeleteAttributesCommand
extends AbstractSdbCommand {
    public DeleteAttributesCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        DeleteAttributesRequest request = new DeleteAttributesRequest().withDomainName(this.determineDomainName()).withItemName(this.determineItemName()).withExpected(this.determineUpdateCondition()).withAttributes(this.determineAttributes());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        this.sdbClient.deleteAttributes(request);
        this.log.trace("Request sent");
    }

    protected Collection<Attribute> determineAttributes() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsSdbAttributes", Collection.class);
    }
}

