/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.IntrospectionSupport;

public class SWFComponent
extends UriEndpointComponent {
    public SWFComponent() {
        super(SWFEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Map clientConfigurationParameters = IntrospectionSupport.extractProperties(parameters, (String)"clientConfiguration.");
        Map sWClientParameters = IntrospectionSupport.extractProperties(parameters, (String)"sWClient.");
        Map startWorkflowOptionsParameters = IntrospectionSupport.extractProperties(parameters, (String)"startWorkflowOptions.");
        SWFConfiguration configuration = new SWFConfiguration();
        configuration.setType(remaining);
        this.setProperties(configuration, parameters);
        configuration.setClientConfigurationParameters(clientConfigurationParameters);
        configuration.setsWClientParameters(sWClientParameters);
        configuration.setStartWorkflowOptionsParameters(startWorkflowOptionsParameters);
        return new SWFEndpoint(uri, this, configuration);
    }
}

