/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.zookeeper.ZooKeeperComponent;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperConnectionManager;
import org.apache.camel.component.zookeeper.ZooKeeperConsumer;
import org.apache.camel.component.zookeeper.ZookeeperProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@ManagedResource(description="ZooKeeper Endpoint")
@UriEndpoint(scheme="zookeeper", title="ZooKeeper", syntax="zookeeper:serverUrls/path", consumerClass=ZooKeeperConsumer.class, label="clustering")
public class ZooKeeperEndpoint
extends DefaultEndpoint {
    @UriParam
    private ZooKeeperConfiguration configuration;
    private ZooKeeperConnectionManager connectionManager;

    public ZooKeeperEndpoint(String uri, ZooKeeperComponent component, ZooKeeperConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.connectionManager = new ZooKeeperConnectionManager(this);
    }

    public Producer createProducer() throws Exception {
        return new ZookeeperProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ZooKeeperConsumer answer = new ZooKeeperConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfiguration(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }

    public ZooKeeperConfiguration getConfiguration() {
        return this.configuration;
    }

    ZooKeeperConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @ManagedAttribute(description="Camel ID")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName() {
        return this.getCamelContext().getManagementName();
    }

    @ManagedAttribute(description="Endpoint Uri", mask=true)
    public String getEndpointUri() {
        return super.getEndpointUri();
    }

    @ManagedAttribute(description="Service State")
    public String getState() {
        ServiceStatus status = this.getStatus();
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute
    public void setPath(String path) {
        this.getConfiguration().setPath(path);
    }

    @ManagedAttribute
    public String getPath() {
        return this.getConfiguration().getPath();
    }

    @ManagedAttribute
    public int getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    @ManagedAttribute
    public void setTimeout(int timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    @ManagedAttribute
    public boolean getRepeat() {
        return this.getConfiguration().isRepeat();
    }

    @ManagedAttribute
    public void setRepeat(boolean shouldRepeat) {
        this.getConfiguration().setRepeat(shouldRepeat);
    }

    @ManagedAttribute
    public List<String> getServers() {
        return this.getConfiguration().getServers();
    }

    @ManagedAttribute
    public void setServers(List<String> servers) {
        this.getConfiguration().setServers(servers);
    }

    @ManagedAttribute
    public boolean isListChildren() {
        return this.getConfiguration().isListChildren();
    }

    @ManagedAttribute
    public void setListChildren(boolean listChildren) {
        this.getConfiguration().setListChildren(listChildren);
    }

    @ManagedAttribute
    public boolean getCreate() {
        return this.getConfiguration().isCreate();
    }

    @ManagedAttribute
    public void setCreate(boolean shouldCreate) {
        this.getConfiguration().setCreate(shouldCreate);
    }

    @ManagedAttribute
    public long getBackoff() {
        return this.getConfiguration().getBackoff();
    }

    @ManagedAttribute
    public void setBackoff(long backoff) {
        this.getConfiguration().setBackoff(backoff);
    }

    @Deprecated
    @ManagedAttribute
    public boolean getAwaitExistence() {
        return this.getConfiguration().shouldAwaitExistence();
    }

    @Deprecated
    @ManagedAttribute
    public void setAwaitExistence(boolean awaitExistence) {
        this.getConfiguration().setAwaitExistence(awaitExistence);
    }

    @ManagedOperation
    public void addServer(String server) {
        this.getConfiguration().addZookeeperServer(server);
    }

    @ManagedOperation
    public void clearServers() {
        this.getConfiguration().getServers().clear();
    }

    public Object getManagedObject(ZooKeeperEndpoint arg0) {
        return this;
    }

    @ManagedAttribute
    public boolean isSendEmptyMessageOnDelete() {
        return this.getConfiguration().isSendEmptyMessageOnDelete();
    }

    @ManagedAttribute
    public void setSendEmptyMessageOnDelete(boolean sendEmptyMessageOnDelete) {
        this.getConfiguration().setSendEmptyMessageOnDelete(sendEmptyMessageOnDelete);
    }

    protected void doStop() throws Exception {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }
}

