/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class GetDataOperation
extends ZooKeeperOperation<byte[]> {
    public GetDataOperation(ZooKeeper connection, String node) {
        super(connection, node);
    }

    @Override
    public OperationResult<byte[]> getResult() {
        try {
            Stat statistics = new Stat();
            if (LOG.isDebugEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Received data from '%s' path with statistics '%s'", this.node, statistics));
                } else {
                    LOG.debug(String.format("Received data from '%s' path ", this.node));
                }
            }
            return new OperationResult<byte[]>(this.connection.getData(this.node, true, statistics), statistics);
        }
        catch (Exception e) {
            return new OperationResult<byte[]>(e);
        }
    }
}

