/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperOperation<ResultType> {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperOperation.class);
    protected static final Class<?>[] CONSTRUCTOR_ARGS = new Class[]{ZooKeeper.class, String.class};
    protected String node;
    protected ZooKeeper connection;
    protected Set<Thread> waitingThreads = new CopyOnWriteArraySet<Thread>();
    protected OperationResult<ResultType> result;
    private boolean producesExchange;
    private boolean cancelled;

    public ZooKeeperOperation(ZooKeeper connection, String node) {
        this(connection, node, true);
    }

    public ZooKeeperOperation(ZooKeeper connection, String node, boolean producesExchange) {
        this.connection = connection;
        this.node = node;
        this.producesExchange = producesExchange;
    }

    public abstract OperationResult<ResultType> getResult();

    public OperationResult<ResultType> get() throws InterruptedException, ExecutionException {
        this.waitingThreads.add(Thread.currentThread());
        this.result = this.getResult();
        return this.result;
    }

    public OperationResult<ResultType> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            for (Thread waiting : this.waitingThreads) {
                waiting.interrupt();
            }
            this.cancelled = true;
        }
        return mayInterruptIfRunning;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isDone() {
        return this.result != null;
    }

    public String getNode() {
        return this.node;
    }

    public boolean shouldProduceExchange() {
        return this.producesExchange;
    }

    public ZooKeeperOperation<?> createCopy() throws Exception {
        return (ZooKeeperOperation)this.getClass().getConstructor(CONSTRUCTOR_ARGS).newInstance(this.connection, this.node);
    }
}

