/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.resourcemanagers.IBoxResourceManager;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.box.BoxComponent;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxConsumer;
import org.apache.camel.component.box.BoxProducer;
import org.apache.camel.component.box.internal.BoxApiCollection;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.component.box.internal.BoxClientHelper;
import org.apache.camel.component.box.internal.BoxPropertiesHelper;
import org.apache.camel.component.box.internal.CachedBoxClient;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;

@UriEndpoint(scheme="box", title="Box", syntax="box:apiName/methodName", consumerClass=BoxConsumer.class, consumerPrefix="consumer", label="api,file,cloud")
public class BoxEndpoint
extends AbstractApiEndpoint<BoxApiName, BoxConfiguration> {
    private static final String SHARED_LINK_PROPERTY = "sharedLink";
    private static final String SHARED_PASSWORD_PROPERTY = "sharedPassword";
    @UriParam
    private BoxConfiguration configuration;
    private CachedBoxClient cachedBoxClient;
    private IBoxResourceManager apiProxy;
    private String sharedLink;
    private String sharedPassword;
    private boolean boxClientShared;

    public BoxEndpoint(String uri, BoxComponent component, BoxApiName apiName, String methodName, BoxConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, BoxApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        if (this.getApiName() == BoxApiName.POLL_EVENTS) {
            throw new IllegalArgumentException("Producer endpoints do not support endpoint prefix " + BoxApiName.POLL_EVENTS.getName());
        }
        return new BoxProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        if (this.getApiName() != BoxApiName.POLL_EVENTS) {
            throw new IllegalArgumentException("Consumer endpoint only supports endpoint prefix " + BoxApiName.POLL_EVENTS.getName());
        }
        BoxConsumer consumer = new BoxConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<BoxConfiguration> getPropertiesHelper() {
        return BoxPropertiesHelper.getHelper();
    }

    protected String getThreadProfileName() {
        return "CamelBox";
    }

    protected void afterConfigureProperties() {
        this.createBoxClient();
        this.sharedLink = this.configuration.getSharedLink();
        this.sharedPassword = this.configuration.getSharedPassword();
        switch ((BoxApiName)this.getApiName()) {
            case SHARED_COMMENTS: 
            case SHARED_FILES: 
            case SHARED_FOLDERS: 
            case SHARED_ITEMS: {
                if (!ObjectHelper.isEmpty((Object)this.sharedLink)) break;
                this.log.warn("Header properties sharedLink and sharedPassword MUST be provided for endpoint {}", (Object)this.getEndpointUri());
                break;
            }
        }
    }

    private void createBoxClient() {
        BoxComponent component = this.getComponent();
        this.boxClientShared = this.configuration.equals(this.getComponent().getConfiguration());
        this.cachedBoxClient = this.boxClientShared ? component.getBoxClient() : BoxClientHelper.createBoxClient(this.configuration);
    }

    public BoxComponent getComponent() {
        return (BoxComponent)super.getComponent();
    }

    public void interceptProperties(Map<String, Object> properties) {
        if (!properties.containsKey(SHARED_LINK_PROPERTY) && !ObjectHelper.isEmpty((Object)this.sharedLink)) {
            properties.put(SHARED_LINK_PROPERTY, this.sharedLink);
        }
        if (!properties.containsKey(SHARED_PASSWORD_PROPERTY) && !ObjectHelper.isEmpty((Object)this.sharedPassword)) {
            properties.put(SHARED_PASSWORD_PROPERTY, this.sharedPassword);
        }
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        if (this.apiProxy == null) {
            this.createApiProxy(args);
        }
        return this.apiProxy;
    }

    private void createApiProxy(Map<String, Object> args) {
        String sharedLink = (String)args.get(SHARED_LINK_PROPERTY);
        String sharedPassword = (String)args.get(SHARED_PASSWORD_PROPERTY);
        switch ((BoxApiName)this.apiName) {
            case SHARED_COMMENTS: 
            case SHARED_FILES: 
            case SHARED_FOLDERS: 
            case SHARED_ITEMS: {
                if (!ObjectHelper.isEmpty((Object)sharedLink)) break;
                throw new IllegalArgumentException("Missing required property sharedLink");
            }
        }
        BoxClient boxClient = this.cachedBoxClient.getBoxClient();
        switch ((BoxApiName)this.apiName) {
            case COLLABORATIONS: {
                this.apiProxy = boxClient.getCollaborationsManager();
                break;
            }
            case COMMENTS: {
                this.apiProxy = boxClient.getCommentsManager();
                break;
            }
            case EVENTS: {
                this.apiProxy = boxClient.getEventsManager();
                break;
            }
            case FILES: {
                this.apiProxy = boxClient.getFilesManager();
                break;
            }
            case FOLDERS: {
                this.apiProxy = boxClient.getFoldersManager();
                break;
            }
            case GROUPS: {
                this.apiProxy = boxClient.getGroupsManager();
                break;
            }
            case SEARCH: {
                this.apiProxy = boxClient.getSearchManager();
                break;
            }
            case SHARED_FILES: {
                this.apiProxy = boxClient.getSharedFilesManager(sharedLink, sharedPassword);
                break;
            }
            case SHARED_FOLDERS: {
                this.apiProxy = boxClient.getSharedFoldersManager(sharedLink, sharedPassword);
                break;
            }
            case SHARED_COMMENTS: {
                this.apiProxy = boxClient.getSharedCommentsManager(sharedLink, sharedPassword);
                break;
            }
            case SHARED_ITEMS: {
                this.apiProxy = boxClient.getSharedItemsManager(sharedLink, sharedPassword);
                break;
            }
            case USERS: {
                this.apiProxy = boxClient.getUsersManager();
                break;
            }
        }
    }

    protected void doStart() throws Exception {
        BoxClientHelper.getOAuthToken(this.configuration, this.cachedBoxClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            if (!this.boxClientShared) {
                BoxClientHelper.closeIdleConnections(this.cachedBoxClient);
            }
        }
        finally {
            super.doStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doShutdown() throws Exception {
        try {
            if (!this.boxClientShared) {
                BoxClientHelper.shutdownBoxClient(this.configuration, this.cachedBoxClient);
            }
        }
        finally {
            this.cachedBoxClient = null;
            super.doShutdown();
        }
    }

    public CachedBoxClient getBoxClient() {
        return this.cachedBoxClient;
    }
}

