/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import org.apache.camel.Endpoint;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DropboxProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxProducer.class);
    protected DropboxEndpoint endpoint;
    protected DropboxConfiguration configuration;

    public DropboxProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.createClient();
            LOG.info("producer dropbox client created");
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.setClient(null);
            LOG.info("producer dropbox client deleted");
        }
        super.doStop();
    }
}

