/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.model;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Table;
import org.apache.camel.bam.EntityManagerCallback;
import org.apache.camel.bam.EntityManagerTemplate;
import org.apache.camel.bam.QueryUtils;
import org.apache.camel.bam.model.EntitySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="CAMEL_PROCESSDEFINITION")
public class ProcessDefinition
extends EntitySupport {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinition.class);
    private String name;

    @Column(unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ProcessDefinition getRefreshedProcessDefinition(EntityManagerTemplate entityManagerTemplate, ProcessDefinition definition) {
        ObjectHelper.notNull((Object)definition, (String)"definition");
        final Long id = definition.getId();
        if (id == null) {
            LOG.warn("No primary key is available!");
            return ProcessDefinition.findOrCreateProcessDefinition(entityManagerTemplate, definition.getName());
        }
        return entityManagerTemplate.execute(new EntityManagerCallback<ProcessDefinition>(){

            @Override
            public ProcessDefinition execute(EntityManager entityManager) {
                return (ProcessDefinition)entityManager.find(ProcessDefinition.class, (Object)id);
            }
        });
    }

    public static ProcessDefinition findOrCreateProcessDefinition(EntityManagerTemplate entityManagerTemplate, final String processName) {
        final String definitionsQuery = "select x from " + QueryUtils.getTypeName(ProcessDefinition.class) + " x where x.name = :processName";
        List<ProcessDefinition> list = entityManagerTemplate.execute(new EntityManagerCallback<List<ProcessDefinition>>(){

            @Override
            public List<ProcessDefinition> execute(EntityManager entityManager) {
                return entityManager.createQuery(definitionsQuery, ProcessDefinition.class).setParameter("processName", (Object)processName).getResultList();
            }
        });
        if (!list.isEmpty()) {
            return list.get(0);
        }
        ProcessDefinition answer = new ProcessDefinition();
        answer.setName(processName);
        entityManagerTemplate.persist(answer);
        return answer;
    }
}

