/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class AddRoutesAtRuntimeTest
extends ContextTestSupport {
    public void testAddRoutesAtRuntime() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AddRoutesAtRuntimeTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new MyDynamcRouteBuilder((CamelContext)this.context, "direct:foo", "mock:foo"));
        this.template.sendBody("direct:foo", (Object)"Bye Camel");
        this.assertMockEndpointsSatisfied();
        AddRoutesAtRuntimeTest.assertEquals((int)2, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new MyDynamcRouteBuilder((CamelContext)this.context, "direct:bar", "mock:bar"));
        this.template.sendBody("direct:bar", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
        AddRoutesAtRuntimeTest.assertEquals((int)3, (int)this.context.getRoutes().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:start");
            }
        };
    }

    private static final class MyDynamcRouteBuilder
    extends RouteBuilder {
        private final String from;
        private final String to;

        private MyDynamcRouteBuilder(CamelContext context, String from, String to) {
            super(context);
            this.from = from;
            this.to = to;
        }

        public void configure() throws Exception {
            this.from(this.from).to(this.to);
        }
    }
}

