/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.IOException;
import java.net.ConnectException;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyManagementException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class ExceptionBuilderTest
extends ContextTestSupport {
    private static final String MESSAGE_INFO = "messageInfo";
    private static final String RESULT_QUEUE = "mock:result";
    private static final String ERROR_QUEUE = "mock:error";
    private static final String BUSINESS_ERROR_QUEUE = "mock:badBusiness";
    private static final String SECURITY_ERROR_QUEUE = "mock:securityError";

    public void testNPE() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm a NPE");
        try {
            this.template.sendBody("direct:a", (Object)"Hello NPE");
            ExceptionBuilderTest.fail((String)"Should have thrown a NullPointerException");
        }
        catch (RuntimeCamelException e) {
            ExceptionBuilderTest.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    public void testIOException() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm somekind of IO exception");
        try {
            this.template.sendBody("direct:a", (Object)"Hello IO");
            ExceptionBuilderTest.fail((String)"Should have thrown a IOException");
        }
        catch (RuntimeCamelException e) {
            ExceptionBuilderTest.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    public void testException() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm just exception");
        try {
            this.template.sendBody("direct:a", (Object)"Hello Exception");
            ExceptionBuilderTest.fail((String)"Should have thrown a Exception");
        }
        catch (RuntimeCamelException e) {
            ExceptionBuilderTest.assertTrue((boolean)(e.getCause() instanceof Exception));
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    public void testMyBusinessException() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(BUSINESS_ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm my business is not going to well");
        try {
            this.template.sendBody("direct:a", (Object)"Hello business");
            ExceptionBuilderTest.fail((String)"Should have thrown a MyBusinessException");
        }
        catch (RuntimeCamelException e) {
            ExceptionBuilderTest.assertTrue((boolean)(e.getCause() instanceof MyBusinessException));
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    public void testSecurityConfiguredWithTwoExceptions() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(SECURITY_ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm some security error");
        try {
            this.template.sendBody("direct:a", (Object)"I am not allowed to do this");
            ExceptionBuilderTest.fail((String)"Should have thrown a GeneralSecurityException");
        }
        catch (RuntimeCamelException e) {
            ExceptionBuilderTest.assertTrue((boolean)(e.getCause() instanceof GeneralSecurityException));
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    public void testSecurityConfiguredWithExceptionList() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm some access error");
        try {
            this.template.sendBody("direct:a", (Object)"I am not allowed to access this");
            ExceptionBuilderTest.fail((String)"Should have thrown a GeneralSecurityException");
        }
        catch (RuntimeCamelException e) {
            ExceptionBuilderTest.assertTrue((boolean)(e.getCause() instanceof IllegalAccessException));
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel(ExceptionBuilderTest.ERROR_QUEUE).redeliveryDelay(0L).maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(NullPointerException.class).maximumRedeliveries(0).setHeader(ExceptionBuilderTest.MESSAGE_INFO, (Expression)this.constant("Damm a NPE"))).to(ExceptionBuilderTest.ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(100L).maximumRedeliveries(3).maximumRedeliveryDelay(30000L).backOffMultiplier(1.0).useExponentialBackOff().setHeader(ExceptionBuilderTest.MESSAGE_INFO, (Expression)this.constant("Damm somekind of IO exception"))).to(ExceptionBuilderTest.ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(Exception.class).redeliveryDelay(100L).maximumRedeliveries(2).setHeader(ExceptionBuilderTest.MESSAGE_INFO, (Expression)this.constant("Damm just exception"))).to(ExceptionBuilderTest.ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(MyBaseBusinessException.class).redeliveryDelay(100L).maximumRedeliveries(3).setHeader(ExceptionBuilderTest.MESSAGE_INFO, (Expression)this.constant("Damm my business is not going to well"))).to(ExceptionBuilderTest.BUSINESS_ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(new Class[]{GeneralSecurityException.class, KeyException.class}).maximumRedeliveries(1).setHeader(ExceptionBuilderTest.MESSAGE_INFO, (Expression)this.constant("Damm some security error"))).to(ExceptionBuilderTest.SECURITY_ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(new Class[]{InstantiationException.class, IllegalAccessException.class, ClassNotFoundException.class}).maximumRedeliveries(0).setHeader(ExceptionBuilderTest.MESSAGE_INFO, (Expression)this.constant("Damm some access error"))).to(ExceptionBuilderTest.ERROR_QUEUE);
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String s = (String)exchange.getIn().getBody(String.class);
                        if ("Hello NPE".equals(s)) {
                            throw new NullPointerException();
                        }
                        if ("Hello IO".equals(s)) {
                            throw new ConnectException("Forced for testing - cannot connect to remote server");
                        }
                        if ("Hello Exception".equals(s)) {
                            throw new CamelExchangeException("Forced for testing", exchange);
                        }
                        if ("Hello business".equals(s)) {
                            throw new MyBusinessException();
                        }
                        if ("I am not allowed to do this".equals(s)) {
                            throw new KeyManagementException();
                        }
                        if ("I am not allowed to access this".equals(s)) {
                            throw new IllegalAccessException();
                        }
                        exchange.getOut().setBody((Object)"Hello World");
                    }
                })).to(ExceptionBuilderTest.RESULT_QUEUE);
            }
        };
    }

    public static class MyBusinessException
    extends MyBaseBusinessException {
        private static final long serialVersionUID = 1L;
    }

    public static class MyBaseBusinessException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

