/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;

public class ExchangeBuilderTest
extends TestCase {
    private static final DefaultCamelContext CONTEXT = new DefaultCamelContext();
    private static final String BODY = "Message Body";
    private static final String KEY = "Header key";
    private static final String VALUE = "Header value";
    private static final String PROPERTY_KEY = "Property key";
    private static final String PROPERTY_VALUE = "Property value";

    public void testBuildAnExchangeWithDefaultPattern() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)CONTEXT);
        Exchange builtExchange = ExchangeBuilder.anExchange((CamelContext)CONTEXT).build();
        ExchangeBuilderTest.assertEquals((Object)exchange.getPattern(), (Object)builtExchange.getPattern());
    }

    public void testBuildAnExchangeWithBodyHeaderAndPattern() throws Exception {
        Exchange exchange = ExchangeBuilder.anExchange((CamelContext)CONTEXT).withBody((Object)BODY).withHeader(KEY, (Object)VALUE).withProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE).withPattern(ExchangePattern.OutIn).build();
        ExchangeBuilderTest.assertEquals((Object)exchange.getIn().getBody(), (Object)BODY);
        ExchangeBuilderTest.assertEquals((Object)exchange.getIn().getHeader(KEY), (Object)VALUE);
        ExchangeBuilderTest.assertEquals((Object)exchange.getPattern(), (Object)ExchangePattern.OutIn);
        ExchangeBuilderTest.assertEquals((Object)exchange.getProperty(PROPERTY_KEY), (Object)PROPERTY_VALUE);
    }
}

