/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;

public class ExpressionBuilderTest
extends TestSupport {
    protected CamelContext camelContext = new DefaultCamelContext();
    protected Exchange exchange = new DefaultExchange(this.camelContext);

    public void testRegexTokenize() throws Exception {
        Expression expression = ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)",");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Islington", "London", "UK"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
        Predicate predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"London"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, true);
        predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"Manchester"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, false);
    }

    public void testRegexReplaceAll() throws Exception {
        Expression expression = ExpressionBuilder.regexReplaceAll((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)"London", (String)"Westminster");
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "Islington,Westminster,UK");
        expression = ExpressionBuilder.regexReplaceAll((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)"London", (Expression)ExpressionBuilder.headerExpression((String)"name"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "Islington,James,UK");
    }

    public void testTokenize() throws Exception {
        Expression expression = ExpressionBuilder.tokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)",");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Islington", "London", "UK"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
        Predicate predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.tokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"London"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, true);
        predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.tokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"Manchester"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, false);
    }

    public void testTokenizeLines() throws Exception {
        Expression expression = ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.bodyExpression(), (String)"[\r|\n]");
        this.exchange.getIn().setBody((Object)"Hello World\nBye World\rSee you again");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Hello World", "Bye World", "See you again"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
    }

    public void testSortLines() throws Exception {
        Expression expression = ExpressionBuilder.sortExpression((Expression)ExpressionBuilderTest.body().tokenize(",").getExpression(), (Comparator)new SortByName());
        this.exchange.getIn().setBody((Object)"Jonathan,Claus,James,Hadrian");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Claus", "Hadrian", "James", "Jonathan"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
    }

    public void testCamelContextPropertiesExpression() throws Exception {
        this.camelContext.getProperties().put("CamelTestKey", "CamelTestValue");
        Expression expression = ExpressionBuilder.camelContextPropertyExpression((String)"CamelTestKey");
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "CamelTestValue");
        expression = ExpressionBuilder.camelContextPropertiesExpression();
        Map properties = (Map)expression.evaluate(this.exchange, Map.class);
        ExpressionBuilderTest.assertEquals((String)"Get a wrong properties size", (int)properties.size(), (int)1);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody((Object)"Hello there!");
        in.setHeader("name", (Object)"James");
        in.setHeader("location", (Object)"Islington,London,UK");
    }

    private static class SortByName
    implements Comparator<String> {
        private SortByName() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

