/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.TestSupport;
import org.apache.camel.TypeConversionException;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;

public class SimpleBuilderTest
extends TestSupport {
    protected Exchange exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());

    public void testPredicate() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimpleBuilderTest.assertTrue((boolean)SimpleBuilder.simple((String)"${body} == 'foo'").matches(this.exchange));
        SimpleBuilderTest.assertFalse((boolean)SimpleBuilder.simple((String)"${body} == 'bar'").matches(this.exchange));
    }

    public void testExpression() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimpleBuilderTest.assertEquals((String)"foo", (String)((String)SimpleBuilder.simple((String)"${body}").evaluate(this.exchange, String.class)));
        SimpleBuilderTest.assertNull((Object)SimpleBuilder.simple((String)"${header.cheese}").evaluate(this.exchange, String.class));
    }

    public void testResultType() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        this.exchange.getIn().setHeader("cool", (Object)true);
        SimpleBuilderTest.assertEquals((Object)"foo", (Object)SimpleBuilder.simple((String)"${body}", String.class).evaluate(this.exchange, Object.class));
        try {
            SimpleBuilder.simple((String)"${body}", Integer.TYPE).evaluate(this.exchange, Object.class);
            SimpleBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (TypeConversionException e) {
            SimpleBuilderTest.assertIsInstanceOf(NumberFormatException.class, e.getCause().getCause());
        }
        SimpleBuilderTest.assertEquals((Object)true, (Object)SimpleBuilder.simple((String)"${header.cool}", Boolean.TYPE).evaluate(this.exchange, Object.class));
        SimpleBuilderTest.assertEquals((Object)"true", (Object)SimpleBuilder.simple((String)"${header.cool}", String.class).evaluate(this.exchange, Object.class));
        SimpleBuilderTest.assertEquals(null, (Object)SimpleBuilder.simple((String)"${header.cool}", Integer.TYPE).evaluate(this.exchange, Object.class));
        SimpleBuilderTest.assertEquals((Object)true, (Object)SimpleBuilder.simple((String)"${header.cool}").resultType(Boolean.class).evaluate(this.exchange, Object.class));
        SimpleBuilderTest.assertEquals((Object)"true", (Object)SimpleBuilder.simple((String)"${header.cool}").resultType(String.class).evaluate(this.exchange, Object.class));
        SimpleBuilderTest.assertEquals(null, (Object)SimpleBuilder.simple((String)"${header.cool}").resultType(Integer.TYPE).evaluate(this.exchange, Object.class));
        SimpleBuilderTest.assertEquals((Object)11, (Object)SimpleBuilder.simple((String)"11", Integer.TYPE).evaluate(this.exchange, Object.class));
    }
}

