/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class XPathHeaderNameTest
extends ContextTestSupport {
    public void testChoiceWithHeaderNamePremium() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:premium");
        mock.expectedBodiesReceived(new Object[]{"<response>OK</response>"});
        mock.expectedHeaderReceived("invoiceDetails", (Object)"<invoice orderType='premium'><person><name>Alan</name></person></invoice>");
        this.template.sendBodyAndHeader("direct:in", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice orderType='premium'><person><name>Alan</name></person></invoice>");
        mock.assertIsSatisfied();
    }

    public void testChoiceWithHeaderNameStandard() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:standard");
        mock.expectedBodiesReceived(new Object[]{"<response>OK</response>"});
        mock.expectedHeaderReceived("invoiceDetails", (Object)"<invoice orderType='standard'><person><name>Alan</name></person></invoice>");
        this.template.sendBodyAndHeader("direct:in", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice orderType='standard'><person><name>Alan</name></person></invoice>");
        mock.assertIsSatisfied();
    }

    public void testChoiceWithHeaderNameUnknown() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:unknown");
        mock.expectedBodiesReceived(new Object[]{"<response>OK</response>"});
        mock.expectedHeaderReceived("invoiceDetails", (Object)"<invoice />");
        this.template.sendBodyAndHeader("direct:in", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice />");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:in").choice().when().xpath("/invoice/@orderType = 'premium'", "invoiceDetails")).to("mock:premium")).when().xpath("/invoice/@orderType = 'standard'", "invoiceDetails")).to("mock:standard")).otherwise().to("mock:unknown")).end();
            }
        };
    }
}

