/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.OrderServiceBean;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanChoseMethodWithMatchingTypeAndSkipSettersTest
extends ContextTestSupport {
    private OrderServiceBean service = new OrderServiceBean();

    @Override
    public void setUp() throws Exception {
        BeanChoseMethodWithMatchingTypeAndSkipSettersTest.deleteDirectory("target/file/order");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("orderService", (Object)this.service);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.service.setConverter(context.getTypeConverter());
        return context;
    }

    public void testSendCSVFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:queue:order");
        mock.expectedBodiesReceived(new Object[]{"66554,123,456"});
        this.template.sendBodyAndHeader("file://target/file/order", (Object)"123,456", "CamelFileName", (Object)"66554.csv");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendXMLData() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:queue:order");
        mock.expectedBodiesReceived(new Object[]{"77889,667,457"});
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><order id=\"77889\"><customer id=\"667\"/><confirm>457</confirm></order>";
        this.template.sendBody("seda:xml", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(new String[]{"file://target/file/order", "seda:xml"}).beanRef("orderService")).to("mock:queue:order");
            }
        };
    }
}

