/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        jndi.bind("myOtherBean", (Object)new MyOtherBean());
        return jndi;
    }

    public void testBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Camel");
            BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            MethodNotFoundException cause = BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
            BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.assertEquals((String)"doSomething()", (String)cause.getMethodName());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testOtherBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:other", (Object)"Camel");
            BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            MethodNotFoundException cause = BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
            BeanMethodWithEmptyParameterAndNoMethodWithNoParameterIssueTest.assertEquals((String)"doSomething()", (String)cause.getMethodName());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething()")).to("mock:result");
                ((RouteDefinition)this.from("direct:other").to("bean:myOtherBean?method=doSomething()")).to("mock:result");
            }
        };
    }

    public static final class MyOtherBean {
        public static void doSomething(Exchange exchange) {
            exchange.getIn().setHeader("foo", (Object)"bar");
        }

        public static void doSomething(Exchange exchange, String foo, String bar) {
            exchange.getIn().setHeader(foo, (Object)bar);
        }
    }

    public static final class MyBean {
        public static void doSomething(Exchange exchange) {
            exchange.getIn().setHeader("foo", (Object)"bar");
        }
    }
}

