/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class BeanOverloadedMethodFQNTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testOrderNoFQN() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(MyOrder)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    public void testOrderNoFQNUnknown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(Unknown)")).to("mock:result");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)new MyOrder());
            BeanOverloadedMethodFQNTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            NoTypeConversionAvailableException cause = BeanOverloadedMethodFQNTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
            BeanOverloadedMethodFQNTest.assertEquals((Object)"Unknown", (Object)cause.getValue());
        }
    }

    public void testOrderNoFQNBoolean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(MyOrder,Boolean)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK;GOLD"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    public void testOrderFQN() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$MyOrder)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    public void testOrderFQNUnknown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$Unknown)")).to("mock:result");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)new MyOrder());
            BeanOverloadedMethodFQNTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            NoTypeConversionAvailableException cause = BeanOverloadedMethodFQNTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
            BeanOverloadedMethodFQNTest.assertEquals((Object)"org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$Unknown", (Object)cause.getValue());
        }
    }

    public void testOrderFQNBoolean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "order(org.apache.camel.component.bean.BeanOverloadedMethodFQNTest$MyOrder,Boolean)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OK;GOLD"});
        this.template.sendBody("direct:start", (Object)new MyOrder());
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyBean {
        public String order(MyOrder order) {
            return "OK";
        }

        public String order(MyOrder order, Boolean gold) {
            return "OK;GOLD";
        }
    }

    public static final class MyOrder {
    }
}

