/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.DynamicRouterDefinition;

public class BeanParameterMethodCallThreeBodyOgnlTest
extends ContextTestSupport {
    public void testBeanParameterValue() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"3"});
        ArrayList<String> body = new ArrayList<String>();
        body.add("A");
        body.add("B");
        body.add("C");
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("router", (Object)new MyRouter());
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((DynamicRouterDefinition)this.from("direct:start").dynamicRouter().method("router")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String bar(String order1, String order2, String order3) {
            TestCase.assertEquals((String)"A", (String)order1);
            TestCase.assertEquals((String)"B", (String)order2);
            TestCase.assertEquals((String)"C", (String)order3);
            return "3";
        }

        public String bar(String order1, String order2) {
            TestCase.assertEquals((String)"A", (String)order1);
            TestCase.assertEquals((String)"B", (String)order2);
            return "2";
        }

        public String bar(String order1) {
            TestCase.assertEquals((String)"A", (String)order1);
            return "1";
        }
    }

    public static class MyRouter {
        public String route(Object body) {
            if (body instanceof List) {
                return "bean:foo?method=bar('A','B','C')";
            }
            return null;
        }
    }
}

