/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class BeanReturnNullTest
extends ContextTestSupport {
    public void testReturnBean() throws Exception {
        MyBean out = (MyBean)this.template.requestBody("direct:start", (Object)"Camel", MyBean.class);
        BeanReturnNullTest.assertNotNull((Object)out);
        BeanReturnNullTest.assertEquals((String)"Camel", (String)out.getName());
    }

    public void testReturnNull() throws Exception {
        Object out = this.template.requestBody("direct:start", (Object)"foo");
        BeanReturnNullTest.assertNull((Object)out);
    }

    public void testReturnNullMyBean() throws Exception {
        MyBean out = (MyBean)this.template.requestBody("direct:start", (Object)"foo", MyBean.class);
        BeanReturnNullTest.assertNull((Object)out);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").bean(BeanReturnNullTest.class, "doSomething");
            }
        };
    }

    public MyBean doSomething(String body) {
        if ("foo".equals(body)) {
            return null;
        }
        return new MyBean(body);
    }

    public static final class MyBean {
        public String name;

        public MyBean(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

