/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithMethodHeaderTest
extends ContextTestSupport {
    private MyBean bean;

    public void testEcho() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"echo Hello World"});
        this.template.sendBody("direct:echo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        BeanWithMethodHeaderTest.assertNull((String)"There should no Bean_METHOD_NAME header", (Object)((Exchange)mock.getExchanges().get(0)).getIn().getHeader("CamelBeanMethodName"));
    }

    public void testEchoWithMethodHeaderHi() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"hi Hello World"});
        ((ValueBuilder)mock.message(0).header("CamelBeanMethodName")).isNull();
        this.template.sendBodyAndHeader("direct:echo", ExchangePattern.InOut, (Object)"Hello World", "CamelBeanMethodName", (Object)"hi");
        this.assertMockEndpointsSatisfied();
    }

    public void testMixedBeanEndpoints() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"hi hi Hello World"});
        ((ValueBuilder)mock.message(0).header("CamelBeanMethodName")).isNull();
        this.template.sendBodyAndHeader("direct:mixed", ExchangePattern.InOut, (Object)"Hello World", "CamelBeanMethodName", (Object)"hi");
        this.assertMockEndpointsSatisfied();
    }

    public void testHi() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"hi Hello World"});
        this.template.sendBody("direct:hi", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testFail() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            BeanWithMethodHeaderTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            BeanWithMethodHeaderTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
            AmbiguousMethodCallException ace = (AmbiguousMethodCallException)e.getCause();
            BeanWithMethodHeaderTest.assertEquals((int)2, (int)ace.getMethods().size());
        }
    }

    public void testMethodNotExists() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:typo").beanRef("myBean", "ups")).to("mock:result");
                }
            });
            BeanWithMethodHeaderTest.fail((String)"Should throw an exception");
        }
        catch (FailedToCreateRouteException e) {
            MethodNotFoundException mnfe = BeanWithMethodHeaderTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause().getCause());
            BeanWithMethodHeaderTest.assertEquals((String)"ups", (String)mnfe.getMethodName());
            BeanWithMethodHeaderTest.assertSame((Object)this.bean, (Object)mnfe.getBean());
        }
    }

    public void testMethodNotExistsOnInstance() throws Exception {
        final MyBean myBean = new MyBean();
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:typo").bean((Object)myBean, "ups")).to("mock:result");
                }
            });
            BeanWithMethodHeaderTest.fail((String)"Should throw an exception");
        }
        catch (FailedToCreateRouteException e) {
            MethodNotFoundException mnfe = BeanWithMethodHeaderTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause().getCause());
            BeanWithMethodHeaderTest.assertEquals((String)"ups", (String)mnfe.getMethodName());
            BeanWithMethodHeaderTest.assertSame((Object)myBean, (Object)mnfe.getBean());
        }
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        this.bean = new MyBean();
        answer.bind("myBean", (Object)this.bean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:echo").beanRef("myBean", "echo")).to("mock:result");
                ((RouteDefinition)this.from("direct:hi").beanRef("myBean", "hi")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:mixed").beanRef("myBean", "echo")).beanRef("myBean", "hi")).to("mock:result");
                ((RouteDefinition)this.from("direct:fail").beanRef("myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String hi(String s) {
            return "hi " + s;
        }

        public String echo(String s) {
            return "echo " + s;
        }
    }
}

