/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FileBeanParameterBindingTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileBeanParameterBindingTest.deleteDirectory("target/foo");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public void testFileToBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/foo", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("file:target/foo").to("bean:foo?method=before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setHeader("bar", (Object)123);
                    }
                })).to("bean:foo?method=after")).to("mock:result");
            }
        };
    }

    public static class MyFooBean {
        public void before(@Header(value="bar") Integer bar, @Header(value="CamelFileName") String name) {
            TestCase.assertNull((String)"There should be no bar", (Object)bar);
            TestCase.assertEquals((String)"hello.txt", (String)name);
        }

        public void after(@Header(value="bar") Integer bar, @Header(value="CamelFileName") String name) {
            TestCase.assertNotNull((String)"There should be bar", (Object)bar);
            TestCase.assertEquals((int)123, (int)bar);
            TestCase.assertEquals((String)"hello.txt", (String)name);
        }
    }
}

