/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DataFormatEndpointStringTest
extends ContextTestSupport {
    public void testUnmarshalUTF8() throws Exception {
        String title = "Hello Thai Elephant \u0e08";
        byte[] bytes = "Hello Thai Elephant \u0e08".getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.template.sendBody("direct:start", (Object)in);
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:unmarshal", MockEndpoint.class);
        mock.setExpectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello Thai Elephant \u0e08"});
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("dataformat:string:unmarshal?charset=UTF-8")).to("mock:unmarshal");
            }
        };
    }
}

