/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;

public class DataSetPreloadTest
extends ContextTestSupport {
    private SimpleDataSet dataSet = new SimpleDataSet(20);
    private String uri = "dataset:foo?preloadSize=5";

    public void testDataSetPreloadSize() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint(this.uri);
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        this.assertMockEndpointsSatisfied();
        DataSetEndpoint ds = (DataSetEndpoint)this.context.getEndpoint(this.uri, DataSetEndpoint.class);
        DataSetPreloadTest.assertEquals((long)5L, (long)ds.getPreloadSize());
        ds.setPreloadSize(7L);
        DataSetPreloadTest.assertEquals((long)7L, (long)ds.getPreloadSize());
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(DataSetPreloadTest.this.uri).to("seda:test");
                this.from("seda:test").to(DataSetPreloadTest.this.uri);
            }
        };
    }
}

