/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeCharsetTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeCharsetTest.deleteDirectory("target/files");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/files?charset=UTF-8", (Object)"Hello World \u4f60\u597d", "CamelFileName", (Object)"report.txt");
    }

    public void testConsumeAndDelete() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World \u4f60\u597d"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumeCharsetTest.assertFalse((String)"File should been deleted", (boolean)new File("target/files/report.txt").exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files/?fileName=report.txt&delete=true&charset=UTF-8").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

