/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileWriter;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerCommitRenameStrategyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerCommitRenameStrategyTest.deleteDirectory("target/done");
        FileConsumerCommitRenameStrategyTest.deleteDirectory("target/reports");
        super.setUp();
    }

    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists("target/done/paris.txt", "Hello Paris");
        this.template.sendBodyAndHeader("file:target/reports", (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameFileExists() throws Exception {
        File file = new File("target/done");
        file.mkdirs();
        try (FileWriter fw = new FileWriter("target/done/london.txt");){
            fw.write("I was there once in London");
            fw.flush();
        }
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello London"});
        this.template.sendBodyAndHeader("file:target/reports", (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        String content = IOConverter.toString((File)new File("target/done/london.txt"), null);
        FileConsumerCommitRenameStrategyTest.assertEquals((String)"The file should have been renamed replacing any existing files", (String)"Hello London", (String)content);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/reports?move=../done/${file:name}&consumer.delay=5000").convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

