/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerNoopTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerNoopTest.deleteDirectory("target/filenoop");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/filenoop", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/filenoop", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
    }

    public void testNoop() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.assertMockEndpointsSatisfied();
        notify.matchesMockWaitTime();
        File file = new File("target/filenoop");
        FileConsumerNoopTest.assertEquals((String)"There should be 2 files", (int)2, (int)file.list().length);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/filenoop?noop=true&initialDelay=0&delay=10").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

