/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class FileSplitInSplitTest
extends ContextTestSupport {
    private final int size = 3;
    private final String comma = ",";

    @Override
    protected void setUp() throws Exception {
        FileSplitInSplitTest.deleteDirectory("target/split");
        super.setUp();
    }

    public void testConcurrentAppend() throws Exception {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 3; ++i) {
            sb.append("Block1 Line " + i + LS);
        }
        sb.append(",");
        for (i = 10; i < 13; ++i) {
            sb.append("Block2 Line " + i + LS);
        }
        this.template.sendBodyAndHeader("file:target/split", (Object)sb.toString(), "CamelFileName", (Object)"input.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        String txt = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/split/outbox/result0.txt"));
        FileSplitInSplitTest.assertNotNull((Object)txt);
        String[] lines = txt.split(LS);
        FileSplitInSplitTest.assertEquals((String)"Should be 4 lines", (int)4, (int)lines.length);
        txt = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/split/outbox/result1.txt"));
        FileSplitInSplitTest.assertNotNull((Object)txt);
        lines = txt.split(LS);
        FileSplitInSplitTest.assertEquals((String)"Should be 4 lines", (int)4, (int)lines.length);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("file:target/split").routeId("foo").noAutoStartup().split((Expression)this.body().tokenize(",")).parallelProcessing().streaming().setProperty("split", (Expression)new SimpleExpression("${property.CamelSplitIndex}"))).split((Expression)this.body().tokenize(LS)).parallelProcessing().streaming().setBody((Expression)this.body().append((Object)":Status=OK").append((Object)LS))).to("file:target/split/outbox?fileExist=Append&fileName=result${property.split}.txt")).end().setBody((Expression)new SimpleExpression("${property.split} complete")).to("file:target/split/outbox?fileExist=Append&fileName=result${property.split}.txt").end().to("mock:result");
            }
        };
    }
}

