/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class FilerConsumerDoneFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerDoneFileNameTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Thread.sleep(250L);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.oneExchangeDone.reset();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/done", (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/done/done");
        FilerConsumerDoneFileNameTest.assertFalse((String)("Done file should be deleted: " + file), (boolean)file.exists());
        file = new File("target/done/.camel/hello.txt");
        FilerConsumerDoneFileNameTest.assertTrue((String)("Original file should be moved: " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/done?doneFileName=done&initialDelay=0&delay=10").to("mock:result");
            }
        };
    }
}

