/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.MulticastDefinition;

public class OptionalPropertiesDslInvalidSyntaxTest
extends ContextTestSupport {
    public void testPlaceholderDslKeyNotFoundTest() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)((MulticastDefinition)((MulticastDefinition)this.from("direct:start").multicast().placeholder("stopOnException", "xxx")).to("mock:a")).throwException((Exception)new IllegalAccessException("Damn"))).to("mock:b");
            }
        });
        try {
            this.context.start();
            OptionalPropertiesDslInvalidSyntaxTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException cause = OptionalPropertiesDslInvalidSyntaxTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OptionalPropertiesDslInvalidSyntaxTest.assertEquals((String)"Property with key [xxx] not found in properties from text: {{xxx}}", (String)cause.getMessage());
        }
    }

    public void testPlaceholderDslSetterNotFoundTest() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)((MulticastDefinition)((MulticastDefinition)this.from("direct:start").multicast().placeholder("xxx", "stop")).to("mock:a")).throwException((Exception)new IllegalAccessException("Damn"))).to("mock:b");
            }
        });
        try {
            this.context.start();
            OptionalPropertiesDslInvalidSyntaxTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException cause = OptionalPropertiesDslInvalidSyntaxTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OptionalPropertiesDslInvalidSyntaxTest.assertEquals((String)"No setter to set property: xxx to: true on: Multicast[[To[mock:a], ThrowException[java.lang.IllegalAccessException], To[mock:b]]]", (String)cause.getMessage());
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/myproperties.properties"));
        return context;
    }
}

