/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestGetEmbeddedRouteTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-test", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    protected int getExpectedNumberOfRoutes() {
        return 3;
    }

    public void testFromRestModel() throws Exception {
        FromRestGetEmbeddedRouteTest.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        FromRestGetEmbeddedRouteTest.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestGetEmbeddedRouteTest.assertNotNull((Object)rest);
        FromRestGetEmbeddedRouteTest.assertEquals((String)"/say/hello", (String)rest.getPath());
        FromRestGetEmbeddedRouteTest.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetEmbeddedRouteTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getRoute().getOutputs().get(1));
        FromRestGetEmbeddedRouteTest.assertEquals((String)"mock:hello", (String)to.getUri());
        rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        FromRestGetEmbeddedRouteTest.assertNotNull((Object)rest);
        FromRestGetEmbeddedRouteTest.assertEquals((String)"/say/bye", (String)rest.getPath());
        FromRestGetEmbeddedRouteTest.assertEquals((int)2, (int)rest.getVerbs().size());
        FromRestGetEmbeddedRouteTest.assertEquals((String)"application/json", (String)((VerbDefinition)rest.getVerbs().get(0)).getConsumes());
        to = FromRestGetEmbeddedRouteTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getRoute().getOutputs().get(1));
        FromRestGetEmbeddedRouteTest.assertEquals((String)"mock:bye", (String)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-bye", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        FromRestGetEmbeddedRouteTest.assertEquals((String)"Hello World", (String)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        FromRestGetEmbeddedRouteTest.assertEquals((String)"Bye World", (String)out2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                ((RouteDefinition)this.rest("/say/hello").get().route().to("mock:hello")).transform((Expression)this.constant("Hello World"));
                ((RouteDefinition)((RouteDefinition)this.rest("/say/bye").get().consumes("application/json").route().to("mock:bye")).transform((Expression)this.constant("Bye World"))).endRest().post().to("mock:update");
            }
        };
    }
}

