/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestGetTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    protected int getExpectedNumberOfRoutes() {
        return 5;
    }

    public void testFromRestModel() throws Exception {
        FromRestGetTest.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        FromRestGetTest.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestGetTest.assertNotNull((Object)rest);
        FromRestGetTest.assertEquals((String)"/say/hello", (String)rest.getPath());
        FromRestGetTest.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestGetTest.assertEquals((String)"direct:hello", (String)to.getUri());
        rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        FromRestGetTest.assertNotNull((Object)rest);
        FromRestGetTest.assertEquals((String)"/say/bye", (String)rest.getPath());
        FromRestGetTest.assertEquals((int)2, (int)rest.getVerbs().size());
        FromRestGetTest.assertEquals((String)"application/json", (String)((VerbDefinition)rest.getVerbs().get(0)).getConsumes());
        to = FromRestGetTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestGetTest.assertEquals((String)"direct:bye", (String)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-bye", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        FromRestGetTest.assertEquals((String)"Hello World", (String)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        FromRestGetTest.assertEquals((String)"Bye World", (String)out2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().consumes("application/json").to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

