/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestUriPrefixTest
extends FromRestGetTest {
    @Override
    public void testFromRestModel() throws Exception {
        FromRestUriPrefixTest.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        FromRestUriPrefixTest.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestUriPrefixTest.assertNotNull((Object)rest);
        FromRestUriPrefixTest.assertEquals((String)"/say/", (String)rest.getPath());
        FromRestUriPrefixTest.assertEquals((int)3, (int)rest.getVerbs().size());
        FromRestUriPrefixTest.assertEquals((String)"/hello", (String)((VerbDefinition)rest.getVerbs().get(0)).getUri());
        FromRestUriPrefixTest.assertEquals((String)"/bye", (String)((VerbDefinition)rest.getVerbs().get(1)).getUri());
        FromRestUriPrefixTest.assertEquals((String)"/hi", (String)((VerbDefinition)rest.getVerbs().get(2)).getUri());
        ToDefinition to = FromRestUriPrefixTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestUriPrefixTest.assertEquals((String)"direct:hello", (String)to.getUri());
        to = FromRestUriPrefixTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(1)).getTo());
        FromRestUriPrefixTest.assertEquals((String)"direct:bye", (String)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-hi", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        FromRestUriPrefixTest.assertEquals((String)"Hello World", (String)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        FromRestUriPrefixTest.assertEquals((String)"Bye World", (String)out2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/").get("/hello").to("direct:hello").get("/bye").consumes("application/json").to("direct:bye").post("/hi").to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

