/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class SameSedaQueueMultipleConsumersDifferenceTest
extends ContextTestSupport {
    public void testSameOptions() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo?multipleConsumers=true", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSameOptionsProducerStillOkay() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAddConsumer() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("seda:foo").routeId("fail").to("mock:fail");
                }
            });
            SameSedaQueueMultipleConsumersDifferenceTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            SameSedaQueueMultipleConsumersDifferenceTest.assertEquals((String)"Cannot use existing queue seda://foo as the existing queue multiple consumers true does not match given multiple consumers false", (String)e.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?multipleConsumers=true").routeId("foo").to("mock:foo");
                this.from("seda:foo?multipleConsumers=true").routeId("bar").to("mock:bar");
            }
        };
    }
}

