/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.seda.SedaEndpoint;

public class SedaConfigureTest
extends ContextTestSupport {
    public void testBlockingQueueConfigured() throws Exception {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo?size=2000", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        LinkedBlockingQueue blockingQueue = SedaConfigureTest.assertIsInstanceOf(LinkedBlockingQueue.class, queue);
        SedaConfigureTest.assertEquals((String)"remainingCapacity", (int)2000, (int)blockingQueue.remainingCapacity());
    }

    public void testConcurrentConsumersConfigured() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo?concurrentConsumers=5", SedaEndpoint.class);
        SedaConfigureTest.assertEquals((String)"concurrentConsumers", (int)5, (int)endpoint.getConcurrentConsumers());
    }

    public void testBlockWhenFull() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo?size=2000&blockWhenFull=true", SedaEndpoint.class);
        SedaConfigureTest.assertTrue((String)"blockWhenFull", (boolean)endpoint.isBlockWhenFull());
    }

    public void testDefaults() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo", SedaEndpoint.class);
        SedaConfigureTest.assertFalse((String)"blockWhenFull: wrong default", (boolean)endpoint.isBlockWhenFull());
        SedaConfigureTest.assertEquals((String)"concurrentConsumers: wrong default", (int)1, (int)endpoint.getConcurrentConsumers());
        SedaConfigureTest.assertEquals((String)"size (remainingCapacity): wrong default", (int)Integer.MAX_VALUE, (int)endpoint.getSize());
        SedaConfigureTest.assertEquals((String)"timeout: wrong default", (long)30000L, (long)endpoint.getTimeout());
    }
}

