/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class SedaFromRouteIdTest
extends ContextTestSupport {
    public void testSedaFromRouteId() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        SedaFromRouteIdTest.assertEquals((String)"foo", (String)((Exchange)foo.getReceivedExchanges().get(0)).getFromRouteId());
        SedaFromRouteIdTest.assertEquals((String)"seda://foo", (String)((Exchange)foo.getReceivedExchanges().get(0)).getFromEndpoint().getEndpointUri());
        SedaFromRouteIdTest.assertEquals((String)"bar", (String)((Exchange)bar.getReceivedExchanges().get(0)).getFromRouteId());
        SedaFromRouteIdTest.assertEquals((String)"seda://bar", (String)((Exchange)bar.getReceivedExchanges().get(0)).getFromEndpoint().getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).to("seda:bar");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

