/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class SedaInOutBigChainedTest
extends ContextTestSupport {
    public void testInOutBigSedaChained() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"start"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"start-a"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"start-a-b"});
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"start-a-b-c"});
        this.getMockEndpoint("mock:e").expectedBodiesReceived(new Object[]{"start-a-b-c-d"});
        this.getMockEndpoint("mock:f").expectedBodiesReceived(new Object[]{"start-a-b-c-d-e"});
        this.getMockEndpoint("mock:g").expectedBodiesReceived(new Object[]{"start-a-b-c-d-e-f"});
        this.getMockEndpoint("mock:h").expectedBodiesReceived(new Object[]{"start-a-b-c-d-e-f-g"});
        String reply = (String)this.template.requestBody("seda:a", (Object)"start", String.class);
        SedaInOutBigChainedTest.assertEquals((String)"start-a-b-c-d-e-f-g-h", (String)reply);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("seda:a").to("mock:a")).transform((Expression)this.simple("${body}-a"))).to("seda:b");
                ((RouteDefinition)((RouteDefinition)this.from("seda:b").to("mock:b")).transform((Expression)this.simple("${body}-b"))).to("seda:c");
                ((RouteDefinition)((RouteDefinition)this.from("seda:c").to("mock:c")).transform((Expression)this.simple("${body}-c"))).to("seda:d");
                ((RouteDefinition)((RouteDefinition)this.from("seda:d").to("mock:d")).transform((Expression)this.simple("${body}-d"))).to("seda:e");
                ((RouteDefinition)((RouteDefinition)this.from("seda:e").to("mock:e")).transform((Expression)this.simple("${body}-e"))).to("seda:f");
                ((RouteDefinition)((RouteDefinition)this.from("seda:f").to("mock:f")).transform((Expression)this.simple("${body}-f"))).to("seda:g");
                ((RouteDefinition)((RouteDefinition)this.from("seda:g").to("mock:g")).transform((Expression)this.simple("${body}-g"))).to("seda:h");
                ((RouteDefinition)this.from("seda:h").to("mock:h")).transform((Expression)this.simple("${body}-h"));
            }
        };
    }
}

