/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;

public class SedaUnitOfWorkTest
extends ContextTestSupport {
    private volatile Object foo;
    private volatile Object kaboom;
    private volatile String sync;
    private volatile String lastOne;

    public void testSedaUOW() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
        notify.matchesMockWaitTime();
        SedaUnitOfWorkTest.assertEquals((String)"onCompleteA", (String)this.sync);
        SedaUnitOfWorkTest.assertEquals((String)"onCompleteA", (String)this.lastOne);
        SedaUnitOfWorkTest.assertEquals((String)"Should have propagated the header inside the Synchronization.onComplete() callback", (Object)"bar", (Object)this.foo);
    }

    public void testSedaUOWWithException() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "kaboom", (Object)"yes");
        notify.matchesMockWaitTime();
        SedaUnitOfWorkTest.assertEquals((String)"onFailureA", (String)this.sync);
        SedaUnitOfWorkTest.assertEquals((String)"onFailureA", (String)this.lastOne);
        SedaUnitOfWorkTest.assertEquals((String)"Should have propagated the header inside the Synchronization.onFailure() callback", (Object)"yes", (Object)this.kaboom);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SedaUnitOfWorkTest.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyUOWProcessor(SedaUnitOfWorkTest.this, "A"))).to("seda:foo");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals(null, (String)SedaUnitOfWorkTest.this.sync);
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        SedaUnitOfWorkTest.this.lastOne = "processor";
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if ("yes".equals(exchange.getIn().getHeader("kaboom"))) {
                            throw new IllegalStateException("kaboom done!");
                        }
                        SedaUnitOfWorkTest.this.lastOne = "processor2";
                    }
                })).to("mock:result");
            }
        };
    }

    private static final class MyUOWProcessor
    implements Processor {
        private SedaUnitOfWorkTest test;
        private String id;

        private MyUOWProcessor(SedaUnitOfWorkTest test, String id) {
            this.test = test;
            this.id = id;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getUnitOfWork().addSynchronization(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    MyUOWProcessor.this.test.sync = "onComplete" + MyUOWProcessor.this.id;
                    MyUOWProcessor.this.test.lastOne = MyUOWProcessor.this.test.sync;
                    MyUOWProcessor.this.test.foo = exchange.getIn().getHeader("foo");
                }

                public void onFailure(Exchange exchange) {
                    MyUOWProcessor.this.test.sync = "onFailure" + MyUOWProcessor.this.id;
                    MyUOWProcessor.this.test.lastOne = MyUOWProcessor.this.test.sync;
                    MyUOWProcessor.this.test.kaboom = exchange.getIn().getHeader("kaboom");
                }
            });
        }
    }
}

