/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;

public class TimerAsyncTest
extends ContextTestSupport {
    public void testSync() throws Exception {
        TimerEndpoint endpoint = (TimerEndpoint)this.context.getEndpoint("timer:foo?synchronous=true", TimerEndpoint.class);
        TimerAsyncTest.assertTrue((String)"Timer endpoint must be synchronous, but it isn't", (boolean)endpoint.isSynchronous());
    }

    public void testAsync() throws Exception {
        TimerEndpoint endpoint = (TimerEndpoint)this.context.getEndpoint("timer:foo", TimerEndpoint.class);
        TimerAsyncTest.assertFalse((String)"Timer endpoint must be asynchronous, but it isn't", (boolean)endpoint.isSynchronous());
    }

    public void testAsyncRouting() throws Exception {
        int threads = 5;
        this.getMockEndpoint("mock:task").expectedMinimumMessageCount(20);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)this.from("timer://foo?fixedRate=true&delay=0&period=200").id("timer")).threads(5, 5).maxQueueSize(1).rejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns).to("log:task")).to("mock:task")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                });
            }
        });
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

