/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.model.RouteDefinition;

public class VmInOutWithErrorTest
extends AbstractVmTestSupport {
    public void testInOutWithError() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template2.requestBody("direct:start", (Object)"Hello World", String.class);
            VmInOutWithErrorTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            VmInOutWithErrorTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            VmInOutWithErrorTest.assertEquals((String)"Damn I cannot do this", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("vm:foo").transform((Expression)this.constant("Bye World"))).throwException((Exception)new IllegalArgumentException("Damn I cannot do this"))).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("vm:foo");
            }
        };
    }
}

