/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class XsltCustomErrorListenerTest
extends TestSupport {
    private MyErrorListener listener = new MyErrorListener();

    public void testErrorListener() throws Exception {
        try {
            SimpleRegistry registry = new SimpleRegistry();
            registry.put((Object)"myListener", (Object)this.listener);
            RouteBuilder builder = this.createRouteBuilder();
            DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
            context.addRoutes((RoutesBuilder)builder);
            context.start();
            XsltCustomErrorListenerTest.fail((String)"Should have thrown an exception due XSLT file not found");
        }
        catch (FailedToCreateRouteException failedToCreateRouteException) {
            // empty catch block
        }
        XsltCustomErrorListenerTest.assertFalse((boolean)this.listener.isWarning());
        XsltCustomErrorListenerTest.assertTrue((String)"My error listener should been invoked", (boolean)this.listener.isError());
        XsltCustomErrorListenerTest.assertTrue((String)"My error listener should been invoked", (boolean)this.listener.isFatalError());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:a").to("xslt:org/apache/camel/builder/xml/example-with-errors.xsl?errorListener=#myListener");
            }
        };
    }

    private class MyErrorListener
    implements ErrorListener {
        private boolean warning;
        private boolean error;
        private boolean fatalError;

        private MyErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            this.warning = true;
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            this.error = true;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.fatalError = true;
        }

        public boolean isWarning() {
            return this.warning;
        }

        public boolean isError() {
            return this.error;
        }

        public boolean isFatalError() {
            return this.fatalError;
        }
    }
}

