/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;

public class XsltFromFileExceptionTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XsltFromFileExceptionTest.deleteDirectory("target/xslt");
        super.setUp();
    }

    public void testXsltFromFileExceptionOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/xslt", (Object)"<hello>world!</hello>", "CamelFileName", (Object)"hello.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/xslt/hello.xml");
        XsltFromFileExceptionTest.assertFalse((String)("File should not exists " + file), (boolean)file.exists());
        file = new File("target/xslt/ok/hello.xml");
        XsltFromFileExceptionTest.assertTrue((String)("File should exists " + file), (boolean)file.exists());
    }

    public void testXsltFromFileExceptionFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/xslt", (Object)"<hello>world!</hello", "CamelFileName", (Object)"hello2.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/xslt/hello2.xml");
        XsltFromFileExceptionTest.assertFalse((String)("File should not exists " + file), (boolean)file.exists());
        file = new File("target/xslt/error/hello2.xml");
        XsltFromFileExceptionTest.assertTrue((String)("File should exists " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("file:target/xslt?moveFailed=error&move=ok").onException(Exception.class).to("mock:error")).end().to("xslt:org/apache/camel/component/xslt/example.xsl").to("mock:result");
            }
        };
    }
}

