/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.Ignore;

@Ignore(value="CamelXsltComponent don't support XSLT_RESOURCE_URI header anymore")
public class XsltFromHeaderOverrideEndpointUriTest
extends ContextTestSupport {
    public void testSendMessageAndHaveItTransformed() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<mail><subject>Hey</subject><body>Hello world!</body></mail>", "CamelXsltResourceUri", (Object)"org/apache/camel/component/xslt/transform_to_foo.xsl");
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        XsltFromHeaderOverrideEndpointUriTest.assertNotNull((String)"The transformed XML should not be null", (Object)xml);
        XsltFromHeaderOverrideEndpointUriTest.assertTrue((xml.indexOf("transformed") > -1 ? 1 : 0) != 0);
        XsltFromHeaderOverrideEndpointUriTest.assertTrue((xml.indexOf("foo") > -1 ? 1 : 0) != 0);
        XsltFromHeaderOverrideEndpointUriTest.assertTrue((xml.indexOf("<subject>Hey</subject>") > -1 ? 1 : 0) != 0);
        XsltFromHeaderOverrideEndpointUriTest.assertTrue((xml.indexOf("<body>Hello world!</body>") > -1 ? 1 : 0) != 0);
        TestBean bean = (TestBean)this.context.getRegistry().lookupByNameAndType("testBean", TestBean.class);
        XsltFromHeaderOverrideEndpointUriTest.assertNotNull((Object)bean);
        XsltFromHeaderOverrideEndpointUriTest.assertEquals((String)"bean.subject", (String)"Hey", (String)bean.getSubject());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/transform.xsl")).multicast().beanRef("testBean")).to("mock:result");
            }
        };
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("testBean", (Object)new TestBean());
        return jndi;
    }
}

