/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import javax.xml.transform.TransformerException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class XsltTransformingExceptionTest
extends ContextTestSupport {
    private static final String GOOD_XML_STRING = "<name>Camel</name>";
    private static final String BAD_XML_STRING = "<staff><programmer></programmer></staff>";

    public void testXsltException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)BAD_XML_STRING);
            XsltTransformingExceptionTest.fail((String)"Except a camel Execution exception here");
        }
        catch (CamelExecutionException ex) {
            XsltTransformingExceptionTest.assertTrue((boolean)(ex.getCause() instanceof TransformerException));
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testXsltWithoutException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)GOOD_XML_STRING);
            XsltTransformingExceptionTest.fail((String)"Except a camel Execution exception here");
        }
        catch (CamelExecutionException ex) {
            XsltTransformingExceptionTest.assertTrue((boolean)(ex.getCause() instanceof TransformerException));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/transformCallEcho.xsl")).to("mock:result");
            }
        };
    }
}

