/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.TypeConversionException;
import org.apache.camel.impl.DefaultExchange;

public class EnumConverterTest
extends ContextTestSupport {
    public void testMandatoryConvertEnum() throws Exception {
        LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Object)"DEBUG");
        EnumConverterTest.assertEquals((Object)LoggingLevel.DEBUG, (Object)level);
    }

    public void testMandatoryConvertWithExchangeEnum() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"WARN");
        EnumConverterTest.assertEquals((Object)LoggingLevel.WARN, (Object)level);
    }

    public void testCaseInsensitive() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        LoggingLevel level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"Warn");
        EnumConverterTest.assertEquals((Object)LoggingLevel.WARN, (Object)level);
        level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"warn");
        EnumConverterTest.assertEquals((Object)LoggingLevel.WARN, (Object)level);
        level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"wARn");
        EnumConverterTest.assertEquals((Object)LoggingLevel.WARN, (Object)level);
        level = (LoggingLevel)this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Exchange)exchange, (Object)"inFO");
        EnumConverterTest.assertEquals((Object)LoggingLevel.INFO, (Object)level);
    }

    public void testMandatoryConvertFailed() throws Exception {
        try {
            this.context.getTypeConverter().mandatoryConvertTo(LoggingLevel.class, (Object)"XXX");
            EnumConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException typeConversionException) {
            // empty catch block
        }
    }
}

