/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.impl.DefaultExchange;

public class InstanceFallbackConverterTest
extends ContextTestSupport {
    public void testInstanceFallbackConverter() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Currency cur = Currency.getInstance(Locale.US);
        String money = (String)this.context.getTypeConverter().convertTo(String.class, (Exchange)exchange, (Object)cur);
        InstanceFallbackConverterTest.assertEquals((String)"Money talks", (String)money);
    }

    public void testInstanceFallbackMandatoryConverter() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Currency cur = Currency.getInstance(Locale.US);
        String money = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Exchange)exchange, (Object)cur);
        InstanceFallbackConverterTest.assertEquals((String)"Money talks", (String)money);
    }

    public void testInstanceFallbackMandatoryFailed() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        try {
            this.context.getTypeConverter().mandatoryConvertTo(Date.class, (Exchange)exchange, (Object)new Timestamp(0L));
            InstanceFallbackConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
    }

    public void testInstanceFallbackFailed() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Date out = (Date)this.context.getTypeConverter().convertTo(Date.class, (Exchange)exchange, (Object)new Timestamp(0L));
        InstanceFallbackConverterTest.assertNull((Object)out);
    }
}

