/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JaxpTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(JaxpTest.class);
    protected TypeConverter converter = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(), (Injector)new ReflectionInjector(), new DefaultFactoryFinderResolver().resolveDefaultFactoryFinder((ClassResolver)new DefaultClassResolver()));

    protected void setUp() throws Exception {
        super.setUp();
        ServiceHelper.startService((Object)this.converter);
    }

    public void testConvertToDocument() throws Exception {
        Document document = (Document)this.converter.convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        JaxpTest.assertNotNull((Object)document);
        LOG.debug("Found document: " + document);
        String text = (String)this.converter.convertTo(String.class, (Object)document);
        JaxpTest.assertTrue((String)("Converted to String: " + text), (boolean)text.endsWith("<hello>world!</hello>"));
    }

    public void testConvertToSource() throws Exception {
        Source source = (Source)this.converter.convertTo(Source.class, (Object)"<hello>world!</hello>");
        JaxpTest.assertNotNull((Object)source);
        LOG.debug("Found document: " + source);
    }

    public void testStreamSourceToDomSource() throws Exception {
        StreamSource streamSource = new StreamSource(new StringReader("<hello>world!</hello>"));
        DOMSource domSource = (DOMSource)this.converter.convertTo(DOMSource.class, (Object)streamSource);
        JaxpTest.assertNotNull((String)"Could not convert to a DOMSource!", (Object)domSource);
        LOG.debug("Found document: " + domSource);
    }

    public void testNodeToSourceThenToInputStream() throws Exception {
        Document document = (Document)this.converter.convertTo(Document.class, (Object)"<?xml version=\"1.0\"?><hello>world!</hello>");
        Element element = document.getDocumentElement();
        Source source = (Source)this.converter.convertTo(Source.class, (Object)element);
        JaxpTest.assertNotNull((String)"Could not convert from Node to Source!", (Object)source);
        LOG.debug("Found source: " + source);
        InputStream in = (InputStream)this.converter.convertTo(InputStream.class, (Object)source);
        JaxpTest.assertNotNull((String)"Could not convert from Source to InputStream!", (Object)in);
        String actualText = IOConverter.toString((InputStream)in, null);
        JaxpTest.assertEquals((String)"Text", (String)"<hello>world!</hello>", (String)actualText);
    }
}

