/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.impl.DefaultExchange;

public class StaticFallbackConverterTest
extends ContextTestSupport {
    public void testStaticFallbackConverter() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        TimeZone tz = TimeZone.getDefault();
        String money = (String)this.context.getTypeConverter().convertTo(String.class, (Exchange)exchange, (Object)tz);
        StaticFallbackConverterTest.assertEquals((String)"Time talks", (String)money);
    }

    public void testStaticFallbackMandatoryConverter() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        TimeZone tz = TimeZone.getDefault();
        String money = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Exchange)exchange, (Object)tz);
        StaticFallbackConverterTest.assertEquals((String)"Time talks", (String)money);
    }

    public void testStaticFallbackMandatoryFailed() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        try {
            this.context.getTypeConverter().mandatoryConvertTo(Date.class, (Exchange)exchange, (Object)new Timestamp(0L));
            StaticFallbackConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
    }

    public void testStaticFallbackFailed() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Date out = (Date)this.context.getTypeConverter().convertTo(Date.class, (Exchange)exchange, (Object)new Timestamp(0L));
        StaticFallbackConverterTest.assertNull((Object)out);
    }
}

