/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.StaxSource;
import org.apache.camel.impl.DefaultExchange;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;

public class StaxSourceTest
extends ContextTestSupport {
    private static final String TEST_XML = "<root xmlns=\"urn:org.apache.camel:test\">Text</root>";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public void testDefaultPrefixInRootElementWithCopyTransformer() throws Exception {
        TransformerFactory trf = TransformerFactory.newInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamReader reader = (XMLStreamReader)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamReader.class, (Object)new StringReader(TEST_XML));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)UTF_8.toString());
        XMLStreamWriter writer = (XMLStreamWriter)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamWriter.class, (Exchange)exchange, (Object)baos);
        StaxSource staxSource = new StaxSource(reader);
        StreamSource templateSource = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/xslt/common/copy.xsl"));
        Transformer transformer = trf.newTransformer(templateSource);
        this.log.info("Used transformer: {}", (Object)transformer.getClass().getName());
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform((Source)staxSource, new StreamResult(baos));
        writer.flush();
        baos.flush();
        Assert.assertThat((Object)new String(baos.toByteArray()), (Matcher)IsEqual.equalTo((Object)TEST_XML));
    }
}

